<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_faq_' . $id . '_settings', $settings);

$output = '<div class="labb-faq-list labb-grid-container ' . labb_get_grid_classes($settings) . '">';

foreach ($settings->faq_list as $faq):

    if (!is_object($faq))
        continue;

    list($animate_class, $animation_attr) = labb_get_animation_atts($faq->faq_animation);

    $child_output = '<div class="labb-grid-item labb-faq-item ' . $animate_class . '" ' . $animation_attr . '>';

    $child_output .= '<' . esc_html($settings->title_tag)
        . ' class="labb-faq-question">' . esc_html($faq->question)
        . '</' . esc_html($settings->title_tag) . '>';

    $child_output .= '<div class="labb-faq-answer">' . do_shortcode($faq->answer) . '</div>';

    $child_output .= '</div><!-- .labb-faq-item -->';

    $output .= apply_filters('labb_faq_item_output', $child_output, $faq, $settings);

endforeach;

$output .= '</div><!-- .labb-faq-list -->';

$output .= '<div class="labb-clear"></div>';

echo apply_filters('labb_faq_output', $output, $settings);